function fault_slip_frictionless(a,alpha,b,colors,D_center,eps_reg,eta_reg,flag_paper,...
    flag_reg,g,G,kappa,K_eff,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,...
    y_plot_max_sigma,y_plot_min_sigma,y_plot_n_pt) 
%
% Computes and plots depletion-induced stresses and fault slip along a frictionless vertical
% fault.  
%

% Retrieve colors:
blue = colors(1,:);
gray = colors(2,:);
green = colors(3,:);
orange = colors(4,:);

% Set fixed parameters:
theta = pi/2; % vertical fault
mu_st = 0; % frictionless fault

% Compute auxiliary variables:
A = G / (2*pi*(1-nu));
C = ((1-2*nu)*alpha*p_inc) / (2*pi*(1-nu)); % scaling parameter, N/m^2

% Compute stresses at the fault excluding the effect of fault slip:
[~,~,~,sigma_C,~,~,~,~,~,~,~,~,~,~,~,~,~,~,y_sigma] = ...
    fault_slip_sigma(a,alpha,b,0,0,D_center,eps_reg,eta_reg,0,flag_reg,g,kappa,K_eff,0,...
    mu_st,y_plot_n_pt,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,0,y_plot_max_sigma,...
    y_plot_min_sigma);

% Compute no-slip intersections:
[y_1,y_2,y_3,y_4] = ... 
    fault_slip_intersect_num(a,alpha,b,0,0,D_center,eps_reg,eta_reg,0,flag_reg,g,kappa,...
    K_eff,0,mu_st,nu,p_0_center,p_inc,phi,rho_f,rho_s,sigma_v_0,theta,0);
y_inter = [y_1,y_2,y_3,y_4]; 

% Compute slip:
y_delta = linspace(y_plot_min_sigma,y_plot_max_sigma,y_plot_n_pt);
delta = ...
      0 * y_delta          .* ( y_delta <= -b       ) ...
    + (C/A) * (-y_delta-b) .* (-b        <   y_delta) .* (y_delta < -a) ...
    + (C/A) * (a-b)        .* (-a        <   y_delta) .* (y_delta <  a) ...
    + (C/A) * (y_delta-b)  .* ( a        <   y_delta) .* (y_delta <  b) ...
    + 0 * y_delta          .* ( b        <=  y_delta);

if flag_paper == 1
 % Read DARTS data:
    data_DARTS_vertical_frictionless_fault = ...
        readmatrix('data_DARTS_vertical_frictionless_fault.txt');
    y_DARTS = data_DARTS_vertical_frictionless_fault(:,1);
    delta_DARTS = data_DARTS_vertical_frictionless_fault(:,4);
end

% Plot shear stresses and slip thresholds:
figure
subplot(1,2,1)
hold on
x_patch_left = [-29.8 -29.8 -15 -15];
y_patch_left = [-150 75 75 -150];
patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
x_patch_right = [15 15 29.8 29.8];
y_patch_right = [-75 150 150 -75];
patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
% Plot colored patches between x = 0 and sigma_C: 
n_seg = 100; % number of segments
y_seg = linspace(y_inter(1),y_inter(2),n_seg);
y_seg_bot = y_seg(1:end-1);
y_seg_top = y_seg(2:end);
y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
x_seg_1 = zeros(n_seg-1,1);
x_seg_2 = zeros(n_seg-1,1);
x_seg_3 = interp1(y_sigma,sigma_C,y_seg_top');
x_seg_4 = interp1(y_sigma,sigma_C,y_seg_bot');
x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
patch(x_patch',y_patch',green,'LineStyle','none')
y_seg = linspace(y_inter(3),y_inter(4),n_seg);
y_seg_bot = y_seg(1:end-1);
y_seg_top = y_seg(2:end);
y_patch = [y_seg_bot' y_seg_top' y_seg_top' y_seg_bot'];
x_seg_1 = zeros(n_seg-1,1);
x_seg_2 = zeros(n_seg-1,1);
x_seg_3 = interp1(y_sigma,sigma_C,y_seg_top');
x_seg_4 = interp1(y_sigma,sigma_C,y_seg_bot');
x_patch = [x_seg_1/1e6 x_seg_2/1e6 x_seg_3/1e6 x_seg_4/1e6];
patch(x_patch',y_patch',green,'LineStyle','none')
x_min = -30;
x_max = 30;
y_min = y_plot_min_sigma;
y_max = y_plot_max_sigma;
line([x_min x_max],[y_inter(4) y_inter(4)],'LineStyle','-','Color',green,'LineWidth',0.5)
line([x_min x_max],[y_inter(1) y_inter(1)],'LineStyle','-','Color',green,'LineWidth',0.5)
line([0 0],[y_min y_max],'LineStyle','-','Color','k','LineWidth',0.5)
line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
plot(sigma_C/1e6,y_sigma,'-r','LineWidth',1.5) % pre-slip Coulomb stresses
plot(-sigma_C/1e6,y_sigma,'-','Color',orange,'LineWidth',1.5) % slip-induced shear stresses
line([-30 -15],[150 150],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
line([-30 -15],[-150 -150],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
line([15 30],[150 150],'LineStyle','-','Color',orange,'LineWidth',1.5) % cosmetic correction
line([15 30],[-150 -150],'LineStyle','-','Color',orange,'LineWidth',1.5) % cosmetic correction
line([15 30],[75 75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
line([15 30],[-75 -75],'LineStyle','-','Color','r','LineWidth',1.5) % cosmetic correction
line([-30 -15],[75 75],'LineStyle','-','Color',orange,'LineWidth',1.5) % cosmetic correction
line([-30 -15],[-75 -75],'LineStyle','-','Color',orange,'LineWidth',1.5) % cosmetic correction
y_post_slip = linspace(-250,250,40);
plot(zeros(40,1),y_post_slip,'o','MarkerSize',3,'MarkerEdgeColor',blue,'MarkerFaceColor',blue)
% line([0 0],[-300 300],'LineStyle','-','Color',blue,'LineWidth',1.5) % post-slip Coulomb str.
hold off
xlabel('$\Sigma_C$, $\breve{\sigma}_{\parallel}$, $\breve{\Sigma}_C$ (MPa) ',...
    'Interpreter','latex','FontSize',11)
ylabel('$\it y \rm(m)$','Interpreter','latex','FontSize',11)
axis([x_min x_max y_min y_max])
text(31.0,y_inter(1),'$\it y_1$','Interpreter','latex','FontSize',11)
text(31.0,y_inter(4),'$\it y_4$','Interpreter','latex','FontSize',11)
box on

subplot(1,2,2)
hold on
x_patch_left = [0.001 0.001 0.05 0.05];
y_patch_left = [-150 75 75 -150];
patch(x_patch_left,y_patch_left,gray,'LineStyle','none')
x_patch_right = [0.15 0.15 0.199 0.199];
y_patch_right = [-75 150 150 -75];
patch(x_patch_right,y_patch_right,gray,'LineStyle','none')
x_min = 0;
x_max = 0.20;
y_min = y_plot_min_sigma;
y_max = y_plot_max_sigma;
line([x_min x_max],[ 150  150],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_min x_max],[-150 -150],'LineStyle','-','Color',blue,'LineWidth',0.5)
line([x_min x_max],[150 150],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[75 75],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[-75 -75],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[-150 -150],'LineStyle',':','Color','k','LineWidth',1)
line([x_min x_max],[0 0],'LineStyle','-','Color','k','LineWidth',0.5)
if flag_paper == 1 % numerical solution
    plot(delta_DARTS,y_DARTS,'^','MarkerIndices',1:25:length(y_DARTS),...
        'MarkerSize',5.0,'MarkerEdgeColor',blue,'MarkerFaceColor',blue);
end
plot(delta,y_delta,'Color','r','LineWidth',1.5)
delta_BO = delta/(2*(1-nu)); % Bourne and Oates (2017) approximate solution
plot(delta_BO,y_delta,'LineStyle','--','Color','r','LineWidth',1.5)
hold off
xlabel('$\delta$ (m) ','Interpreter','latex','FontSize',11)
axis([x_min x_max y_min y_max])
text(0.202,-150,'$\it \tilde{y}_1$','Interpreter','latex','FontSize',11)
text(0.202,150,'$\it \tilde{y}_4$','Interpreter','latex','FontSize',11)
box on
